# ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ********************************************************************************

import mdPhonePythonWrapper

#/********************** LICENSE STRINGS **********************
#*     To unlock the full functionality of Phone Object,      *
#* please call a sales representative at 1-800-MELISSA ext. 3 *
#*         (1-800-635-4772 x3) for a license string.          *
#*  Phone Object will function in Demo mode without a valid   *
#*        license and validate Nevada Phones only             *
#           REPLACE "DEMO" with LICENSE STRING                *
#**************************************************************/

# Put your License String and Path to Phone Object Data Files here...

License = r"DEMO"

# ********************** DATA FILE PATH  ***********************
#  File location path is set to the default Data File location
#  Change this value if you installed the data files to a       
#  different folder.                                            
#  The Data Files Directory must contain the following files:   
#  mdAddr.dat, mdPhone.dat, mdPhone.idx, and ZIPNPA.txt
# **************************************************************

DataPath = r"C:\Program Files\Melissa Data\DQT\Data"

# Create Global Phone Object
mdGlobalPhone = mdPhonePythonWrapper.mdGlobalPhone()

# Create Phone Object
mdPhone = mdPhonePythonWrapper.mdPhone()

# Set License String
mdGlobalPhone.SetLicenseString(License)
mdPhone.SetLicenseString(License)

print "\n"

# Initialize Phone Obj Data Files
result = mdPhone.Initialize(DataPath)
if result != 0:
    print "Initialize Error: ", mdPhone.GetInitializeErrorString()
    exit()

# Initialize Global Phone Obj Data Files	
globalPhoneResult = mdGlobalPhone.Initialize(DataPath)
if globalPhoneResult != 0:
    print "Initialize Error: ", mdGlobalPhone.GetInitializeErrorString()
    exit()
	

print "=======Global Phone Object Information======="
print "  BuildNumber: ", mdGlobalPhone.GetBuildNumber() 
print "Database Date: ", mdGlobalPhone.GetDatabaseDate()
print "=============================================\n"

GlobalPhone = raw_input("Enter Phone Number (Ex: 422304850): ")
Country = raw_input("    Enter Country Name (Ex: JPN): ")
CountryOfOrigin = raw_input(" Enter Country of Origin(Ex: USA): ")

print "\n"
mdGlobalPhone.Lookup(GlobalPhone, Country, CountryOfOrigin)     
GlobalResultsString = mdGlobalPhone.GetResults()
    
if (GlobalResultsString.find("PE")!= -1):
	if (GlobalResultsString.find("PE01")!= -1):
		print "Error in Lookup: Area Code Not valid"
	if (GlobalResultsString.find("PE02")!= -1):
		print "Error in Lookup: Blank Phone Number"
	if (GlobalResultsString.find("PE03")!= -1):
		print "Error in Lookup: Phone Number Not valid"
	if (GlobalResultsString.find("PE04")!= -1):
		print "Error in Lookup: Input has Multiple Matches"
	if (GlobalResultsString.find("PE05")!= -1):
		print "Error in Lookup: Phone Prefix Not Valid"
	if (GlobalResultsString.find("PE06")!= -1):
		print "Error in Lookup: Zip Code Not Valid"
	if (GlobalResultsString.find("PE08")!= -1):
		print "Error in Lookup: No country inputted"
	if (GlobalResultsString.find("PE09")!= -1):
		print "Error in Lookup: Subscriber number out of range"
	if (GlobalResultsString.find("PE10")!= -1):
		print "Error in Lookup: Incorrect / misspelled country input"
				
        
if ((GlobalResultsString.find("PS01")!= -1) or (GlobalResultsString.find("PS02")!= -1)):
	if (GlobalResultsString.find("PS01")!= -1):
		print "      Validated: Phone Validated to 10 Digits"
	elif (GlobalResultsString.find("PS02")!= -1):
		print "      Validated: Phone Validated to 7 Digits"
				
	if (GlobalResultsString.find("PS07")!= -1):
		print "  Exchange Type: Cellular"
	elif (GlobalResultsString.find("PS08")!= -1):
		print "  Exchange Type: Land Line"
	elif (GlobalResultsString.find("PS09")!= -1):
		print "  Exchange Type: VOIP"
	elif (GlobalResultsString.find("PS13")!= -1):
	   print "  Exchange Type: International toll-free"
	elif (GlobalResultsString.find("ps14")!= -1):
		print "  Exchange Type: International number incurring higher charge rate"
	   
	if (GlobalResultsString.find("PS10")!= -1):
		print "     Phone Type: Residential"
	elif (GlobalResultsString.find("PS11")!= -1):
		print "     Phone Type: Business"
	elif (GlobalResultsString.find("PS12")!= -1):
		print "     Phone Type: Small/Home Office"
				    
print "\n==== Global Phone Obj Lookup Results====\n"
print "                 Phone Number: ", mdGlobalPhone.GetPhoneNumber()
print "\n              Nation Prefix: ", mdGlobalPhone.GetNationPrefix()
print "\n	    International Prefix: ", mdGlobalPhone.GetInternationalPrefix()
print "\n  National Destination Code: ", mdGlobalPhone.GetNationalDestinationCode()
print "\n            Locality (City): ", mdGlobalPhone.GetLocality() 
print "\nAdministrative Area (State): ", mdGlobalPhone.GetAdministrativeArea()
print "\n                    Country: ", mdGlobalPhone.GetCountry()
print "\n                County Code: ", mdGlobalPhone.GetCountryCode() 
print "\n                        DST: ", mdGlobalPhone.GetDST()
print "\n                   Language: ", mdGlobalPhone.GetLanguage()
print "\n                   Latitude: ", mdGlobalPhone.GetLatitude() 
print "\n                  Longitude: ", mdGlobalPhone.GetLongitude()
print "\n          Subscriber Number: ", mdGlobalPhone.GetSubscriberNumber()
print "\n                        UTC: ", mdGlobalPhone.GetUTC()
print "\n               Results Code: ", mdGlobalPhone.GetResults()
print "\n"

print "=======Phone Object Information======="
print "  BuildNumber: ", mdPhone.GetBuildNumber() 
print "Database Date: ", mdPhone.GetDatabaseDate()
print "======================================\n"

Phone = raw_input("Enter Phone Number: ")

while (Phone == '0'):
	print "Please enter a phone number: "
	Phone = raw_input("Enter Phone Number: ")

Zip = raw_input("    Enter Zip Code: ")

print "\n"
mdPhone.Lookup(Phone,Zip)     
ResultsString = mdPhone.GetResults()
    
if (ResultsString.find("PE")!= -1):
	if (ResultsString.find("PE01")!= -1):
		print "Error in Lookup: Area Code Not valid"
	if (ResultsString.find("PE02")!= -1):
		print "Error in Lookup: Blank Phone Number"
	if (ResultsString.find("PE03")!= -1):
		print "Error in Lookup: Phone Number Not valid"
	if (ResultsString.find("PE04")!= -1):
		print "Error in Lookup: Input has Multiple Matches"
	if (ResultsString.find("PE05")!= -1):
		print "Error in Lookup: Phone Prefix Not Valid"
	if (ResultsString.find("PE06")!= -1):
		print "Error in Lookup: Zip Code Not Valid"
				
        
if ((ResultsString.find("PS01")!= -1) or (ResultsString.find("PS02")!= -1)):
	if (ResultsString.find("PS01")!= -1):
		print "      Validated: Phone Validated to 10 Digits"
	elif (ResultsString.find("PS02")!= -1):
		print "      Validated: Phone Validated to 7 Digits"
				
	if (ResultsString.find("PS07")!= -1):
		print "  Exchange Type: Cellular"
	elif (ResultsString.find("PS08")!= -1):
		print "  Exchange Type: Land Line"
	elif (ResultsString.find("PS09")!= -1):
		print "  Exchange Type: VOIP"

	if (ResultsString.find("PS10")!= -1):
		print "     Phone Type: Residential"
	elif (ResultsString.find("PS11")!= -1):
		print "     Phone Type: Business"
	elif (ResultsString.find("PS12")!= -1):
		print "     Phone Type: Small/Home Office"
				    
print "\n===============Lookup Results=================\n"
print "           Area Code: ", mdPhone.GetAreaCode()
print "              Prefix: ", mdPhone.GetPrefix()
print "              Suffix: ", mdPhone.GetSuffix()
print "                City: ", mdPhone.GetCity() 
print "               State: ", mdPhone.GetState()
print "Distance ZipCentroid: ", mdPhone.GetDistance()
print "         County Name: ", mdPhone.GetCountyName() 
print "         County Fips: ", mdPhone.GetCountyFips()
print "        Country Code: ", mdPhone.GetCountryCode()
print "            Timezone: ", mdPhone.GetTimeZone() 
print "       Timezone Code: ", mdPhone.GetTimeZoneCode()
print "                 MSA: ", mdPhone.GetMsa()
print "                PMSA: ", mdPhone.GetPmsa()
print "        Results Code: ", mdPhone.GetResults()
print "\n"
        
latit = float(mdPhone.GetLatitude())
lngit = float(mdPhone.GetLongitude())
print "            Latitude: ", latit
print "           Longitude: ", lngit             
    
print "\n"
print "=================================================="
print " Compute Distance and Bearing to another location"
print " Lat / Long of US Capital: 38.889722  -77.0075 "
print "=================================================="
print "     Distance : ", mdPhone.ComputeDistance(latit, lngit, 38.889722, -77.0075), " miles"
print "      Bearing : ", mdPhone.ComputeBearing(latit, lngit, 38.889722, -77.0075), " degrees"

print "\n"
    	 	
				
if (ResultsString.find("PS06")!= -1):
	print "PS06: updated exchange"
			  
			  
if(Zip != ""):
	mdPhone.CorrectAreaCode(Phone,Zip)
	print "\n==========Correct Area Code Results============\n"
	print "    Area Code: ", mdPhone.GetAreaCode()
	print "New Area Code: ", mdPhone.GetNewAreaCode() 
	print "       Prefix: ", mdPhone.GetPrefix()
	print "       Suffix: ", mdPhone.GetSuffix()
	print "    Extension: ", mdPhone.GetExtension() 

	print "\n"